/*
 * Decompiled with CFR 0.152.
 */
package main;

import ControlSerial.CommFormat;
import Data.SystemData;
import Utility.SongUtil;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import main.CalFXMLController;
import main.CommOpenFXMLController;
import main.DataSaveFXMLController;
import main.HelpAboutFXMLController;
import main.InfoSFXMLController;
import main.PasswdFXMLController;
import main.SetupFXMLController;

public class MainScreenController
implements Initializable {
    SystemData sysData = SystemData.getInstance();
    private boolean threadStatus = true;
    @FXML
    private Button commOpen;
    @FXML
    private Button calBtn;
    @FXML
    private ImageView startstopImage;
    @FXML
    private Circle stsLed;
    @FXML
    private Label conLabel;
    @FXML
    private TextField tempText;
    @FXML
    private TextField humiText;
    @FXML
    private TextField tvocText;
    @FXML
    private TextField lightText;
    @FXML
    private TextField coText;
    @FXML
    private TextField no2Text;
    @FXML
    private TextField o3Text;
    @FXML
    private TextField hchoText;
    @FXML
    private TextField motionText;
    @FXML
    private TextField co2Text;
    @FXML
    private TextField soundText;
    @FXML
    private TextField dust25Text;
    @FXML
    private TextField dust10Text;
    @FXML
    private TextField loraText;
    @FXML
    private TabPane mainTab;
    @FXML
    private Label fwVersionLabel;
    private StringBuilder fieldContent = new StringBuilder("");
    @FXML
    private Button setupBtn;
    @FXML
    private ImageView startstopImage1;
    @FXML
    private Button helpBtn;
    @FXML
    private ImageView startstopImage11;
    @FXML
    private TextField dust01Text;
    @FXML
    private MenuItem exitBtn;
    @FXML
    private TextField tempText1;
    @FXML
    private TextField nh3Text;
    @FXML
    private Label conLabel1;
    @FXML
    private Label conLabel11;
    @FXML
    private Label wifiIP;
    @FXML
    private Label wifiLevel;
    @FXML
    private TextArea debugText;
    @FXML
    private Tab debugTab;
    @FXML
    private Tab measTab;
    @FXML
    private Label dataLabel;
    LocalDateTime dataTime = LocalDateTime.now();
    StringBuilder disDataStr = new StringBuilder();

    @FXML
    void exitBtnClicked(ActionEvent event) {
        this.sysData.primaryStage.close();
    }

    @FXML
    void commOpenOnAction(ActionEvent event) {
        CommOpenFXMLController open = new CommOpenFXMLController(this.sysData.primaryStage);
        open.show();
    }

    @FXML
    void calBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            PasswdFXMLController pin = new PasswdFXMLController(this.sysData.primaryStage);
            boolean pass = pin.show();
            if (pass) {
                CalFXMLController open = new CalFXMLController(this.sysData.primaryStage);
                open.show();
            }
        } else {
            System.out.println("Comport Open Error");
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    @FXML
    void setupBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            SetupFXMLController open = new SetupFXMLController(this.sysData.primaryStage);
            open.show();
        } else {
            System.out.println("Comport Open Error");
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    private void popupScreen() {
        InfoSFXMLController open = new InfoSFXMLController(this.sysData.primaryStage);
        open.show();
    }

    @FXML
    void resetBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            boolean sts = SongUtil.confirmBox("Warning", "LEO will Reset", "LEO reboots. are you sure?");
            if (sts) {
                CommFormat txFormat = new CommFormat();
                txFormat.setAddr(1);
                txFormat.setFuncCode(33);
                txFormat.setLength(1);
                txFormat.setTxData("REQ,");
                this.sysData.comm.setTxArray(txFormat);
                this.popupScreen();
            }
        } else {
            System.out.println("Comport Open Error");
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    @FXML
    void helpBtnOnAction(ActionEvent event) {
        HelpAboutFXMLController open = new HelpAboutFXMLController(this.sysData.primaryStage);
        open.show();
    }

    public void onLed() {
        this.stsLed.setFill((Paint)Color.ORANGE);
    }

    public void offLed() {
        this.stsLed.setFill((Paint)Color.DARKGRAY);
    }

    public void onLabel() {
        this.conLabel.setText("Connection OK");
    }

    public void offLabel() {
        this.conLabel.setText("No Connection");
    }

    public void threadExit() {
        this.threadStatus = false;
    }

    public void addDebugText(String str) {
        Platform.runLater(() -> this.debugText.appendText(SongUtil.nowDateTimeToFormatString() + "=>" + str + "\n"));
    }

    private void commOut(int addr, int func, int len, String fmt) {
        if (this.sysData.comm.comPort) {
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(addr);
            txFormat.setFuncCode(func);
            txFormat.setLength(len);
            txFormat.setTxData(fmt);
            this.sysData.comm.setTxArray(txFormat);
        } else {
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean usbFileSave(String item) {
        boolean sts = false;
        OutputStreamWriter fw = null;
        try {
            String fileName = this.sysData.fileName.toString();
            fw = new FileWriter(fileName, true);
            fw.write(item);
            fw.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            Logger.getLogger(MainScreenController.class.getName()).log(Level.SEVERE, null, ex);
            sts = false;
        }
        finally {
            try {
                fw.close();
                sts = false;
            }
            catch (IOException ex) {
                Logger.getLogger(MainScreenController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return sts;
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.sysData.dataBase.dBTableCreate("aSensor");
        this.sysData.dataBase.dBDataSave("aSensor", "2005, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15");
        this.mainTab.getSelectionModel().selectedItemProperty().addListener((ov, oldTab, newTab) -> {
            if (newTab == this.measTab) {
                System.out.println("Measure Select");
                this.sysData.commKind = false;
            } else if (newTab == this.debugTab) {
                System.out.println("Debug Select");
                this.sysData.commKind = true;
            }
        });
        this.sysData.mainScreen = this;
        new Thread(() -> {
            while (this.threadStatus) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(CommOpenFXMLController.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (!this.sysData.connect) continue;
                Platform.runLater(() -> {
                    boolean tempUse = true;
                    boolean humiUse = true;
                    boolean tvocUse = true;
                    boolean lightUse = true;
                    boolean coUse = true;
                    boolean no2Use = true;
                    boolean o3Use = true;
                    boolean hchoUse = true;
                    boolean co2Use = true;
                    boolean soundUse = true;
                    boolean dust25Use = true;
                    boolean dust10Use = true;
                    boolean dust01Use = true;
                    boolean motionUse = true;
                    boolean nh3Use = true;
                    if (this.sysData.sensor.Temp < -50.0) {
                        tempUse = false;
                    }
                    if (this.sysData.sensor.Humi < -50.0) {
                        humiUse = false;
                    }
                    if (this.sysData.sensor.TVOC < -50.0) {
                        tvocUse = false;
                    }
                    if (this.sysData.sensor.Light < -50.0) {
                        lightUse = false;
                    }
                    if (this.sysData.sensor.CO < -50.0) {
                        coUse = false;
                    }
                    if (this.sysData.sensor.NO2 < -50.0) {
                        no2Use = false;
                    }
                    if (this.sysData.sensor.O3 < -50.0) {
                        o3Use = false;
                    }
                    if (this.sysData.sensor.HCHO < -50.0) {
                        hchoUse = false;
                    }
                    if ((double)this.sysData.sensor.MotionDetect < -50.0) {
                        motionUse = false;
                    }
                    if (this.sysData.sensor.CO2 < -50.0) {
                        co2Use = false;
                    }
                    if (this.sysData.sensor.sound < -50.0) {
                        soundUse = false;
                    }
                    if (this.sysData.sensor.Dust25 < -50.0) {
                        dust25Use = false;
                    }
                    if (this.sysData.sensor.Dust10 < -50.0) {
                        dust10Use = false;
                    }
                    if (this.sysData.sensor.Dust01 < -50.0) {
                        dust01Use = false;
                    }
                    if (this.sysData.sensor.NH3 < -50.0) {
                        nh3Use = false;
                    }
                    String temp = String.format("%3.1f", this.sysData.sensor.Temp);
                    String temp1 = String.format("%3.1f", this.sysData.sensor.Temp * 1.8 + 32.0);
                    String humi = String.format("%3.1f", this.sysData.sensor.Humi);
                    String tvoc = String.format("%3.2f", this.sysData.sensor.TVOC);
                    String light = String.format("%3.1f", this.sysData.sensor.Light);
                    String co = String.format("%3.2f", this.sysData.sensor.CO);
                    String no2 = String.format("%3.2f", this.sysData.sensor.NO2);
                    String o3 = String.format("%3.2f", this.sysData.sensor.O3);
                    String hcho = String.format("%3.2f", this.sysData.sensor.HCHO);
                    String motion = this.sysData.sensor.MotionDetect == 0 ? "not detect" : "detect";
                    String co2 = String.format("%3.1f", this.sysData.sensor.CO2);
                    String sound = String.format("%3.1f", this.sysData.sensor.sound);
                    String dust25 = String.format("%3.1f", this.sysData.sensor.Dust25);
                    String dust10 = String.format("%3.1f", this.sysData.sensor.Dust10);
                    String dust01 = String.format("%3.1f", this.sysData.sensor.Dust01);
                    String nh3 = String.format("%3.2f", this.sysData.sensor.NH3);
                    String loraSts = String.format("%d", this.sysData.sensor.loraSts);
                    this.disDataStr.setLength(0);
                    if (tempUse) {
                        this.tempText.setText(temp);
                        this.tempText1.setText(temp1);
                        this.disDataStr.append("TEMP-C,");
                        this.disDataStr.append(temp);
                        this.disDataStr.append(",");
                        this.disDataStr.append("TEMP-F,");
                        this.disDataStr.append(temp1);
                        this.disDataStr.append(",");
                    } else {
                        this.disDataStr.append("TEMP,");
                        this.tempText.setText("Not Use");
                        this.tempText1.setText("Not Use");
                        this.disDataStr.append("not use,");
                    }
                    if (humiUse) {
                        this.humiText.setText(humi);
                        this.disDataStr.append("HUMI,");
                        this.disDataStr.append(humi);
                        this.disDataStr.append(",");
                    } else {
                        this.disDataStr.append("HUMI,");
                        this.humiText.setText("Not Use");
                        this.disDataStr.append("not use,");
                    }
                    if (co2Use) {
                        this.disDataStr.append("CO2,");
                        this.co2Text.setText(co2);
                        this.disDataStr.append(co2);
                        this.disDataStr.append(",");
                    } else {
                        this.disDataStr.append("CO2,");
                        this.co2Text.setText("Not Use");
                        this.disDataStr.append("not use,");
                    }
                    if (coUse) {
                        this.disDataStr.append("CO,");
                        this.coText.setText(co);
                        this.disDataStr.append(co);
                        this.disDataStr.append(",");
                    } else {
                        this.disDataStr.append("CO,");
                        this.coText.setText("Not Use");
                        this.disDataStr.append("not use,");
                    }
                    if (tvocUse) {
                        this.disDataStr.append("TVOC,");
                        this.tvocText.setText(tvoc);
                        this.disDataStr.append(tvoc);
                        this.disDataStr.append(",");
                    } else {
                        this.disDataStr.append("TVOC,");
                        this.tvocText.setText("Not Use");
                        this.disDataStr.append("not use,");
                    }
                    if (dust10Use) {
                        this.disDataStr.append("PM10,");
                        this.dust10Text.setText(dust10);
                        this.disDataStr.append(dust10);
                        this.disDataStr.append(",");
                    } else {
                        this.disDataStr.append("PM10,");
                        this.dust10Text.setText("Not Use");
                        this.disDataStr.append("not use,");
                    }
                    if (dust25Use) {
                        this.disDataStr.append("PM2.5,");
                        this.dust25Text.setText(dust25);
                        this.disDataStr.append(dust25);
                        this.disDataStr.append(",");
                    } else {
                        this.disDataStr.append("PM2.5,");
                        this.dust25Text.setText("Not Use");
                        this.disDataStr.append("not use,");
                    }
                    if (dust01Use) {
                        this.disDataStr.append("PM0.1,");
                        this.dust01Text.setText(dust01);
                        this.disDataStr.append(dust01);
                        this.disDataStr.append(",");
                    } else {
                        this.disDataStr.append("PM0.1,");
                        this.dust01Text.setText("Not Use");
                        this.disDataStr.append("not use,");
                    }
                    if (hchoUse) {
                        this.disDataStr.append("HCHO,");
                        this.hchoText.setText(hcho);
                        this.disDataStr.append(hcho);
                        this.disDataStr.append(",");
                    } else {
                        this.disDataStr.append("HCHO,");
                        this.hchoText.setText("Not Use");
                        this.disDataStr.append("not use,");
                    }
                    if (no2Use) {
                        this.disDataStr.append("NO2,");
                        this.no2Text.setText(no2);
                        this.disDataStr.append(no2);
                        this.disDataStr.append(",");
                    } else {
                        this.disDataStr.append("NO2,");
                        this.no2Text.setText("Not Use");
                        this.disDataStr.append("not use,");
                    }
                    if (o3Use) {
                        this.disDataStr.append("O3,");
                        this.o3Text.setText(o3);
                        this.disDataStr.append(o3);
                        this.disDataStr.append(",");
                    } else {
                        this.disDataStr.append("O3,");
                        this.o3Text.setText("Not Use");
                        this.disDataStr.append("not use,");
                    }
                    if (nh3Use) {
                        this.disDataStr.append("NH3,");
                        this.nh3Text.setText(nh3);
                        this.disDataStr.append(nh3);
                        this.disDataStr.append(",");
                    } else {
                        this.disDataStr.append("NH3,");
                        this.nh3Text.setText("Not Use");
                        this.disDataStr.append("not use,");
                    }
                    if (lightUse) {
                        this.disDataStr.append("LIGHT,");
                        this.lightText.setText(light);
                        this.disDataStr.append(light);
                        this.disDataStr.append(",");
                    } else {
                        this.disDataStr.append("LIGHT,");
                        this.lightText.setText("Not Use");
                        this.disDataStr.append("not use,");
                    }
                    if (soundUse) {
                        this.disDataStr.append("NOISE,");
                        this.soundText.setText(sound);
                        this.disDataStr.append(sound);
                        this.disDataStr.append(",");
                    } else {
                        this.disDataStr.append("NOISE,");
                        this.soundText.setText("Not Use");
                        this.disDataStr.append("not use,");
                    }
                    if (motionUse) {
                        this.disDataStr.append("MOTION,");
                        this.motionText.setText(motion);
                        this.disDataStr.append(motion);
                    } else {
                        this.disDataStr.append("MOTION,");
                        this.motionText.setText("Not Use");
                        this.disDataStr.append("not use");
                    }
                    this.loraText.setText(loraSts);
                    this.fwVersionLabel.setText(this.sysData.sensor.fwVersion.toString());
                    if (this.sysData.sensor.wifiIP.toString().equals("0.0.0.0")) {
                        this.wifiIP.setText("-------");
                    } else {
                        this.wifiIP.setText(this.sysData.sensor.wifiIP.toString());
                    }
                    if (this.sysData.sensor.wifiLevel < 0) {
                        this.wifiLevel.setText(String.format("%3d", this.sysData.sensor.wifiLevel));
                    } else {
                        this.wifiLevel.setText("-----");
                    }
                    if (this.sysData.autoStart == 1) {
                        LocalDateTime nowTime = LocalDateTime.now();
                        long sec = ChronoUnit.SECONDS.between(this.dataTime, nowTime);
                        if (sec >= (long)this.sysData.intervalTime) {
                            this.usbFileSave(SongUtil.nowDateTimeToFormatString() + "," + this.disDataStr.toString() + "\n");
                            System.out.println("Data=>" + this.disDataStr.toString());
                            this.dataTime = LocalDateTime.now();
                            this.dataLabel.setText(SongUtil.nowDateTimeToFormatString() + ": Saved");
                        }
                    } else {
                        this.dataTime = LocalDateTime.now();
                    }
                });
            }
        }).start();
    }

    @FXML
    private void clrBtnOnAction(ActionEvent event) {
        this.debugText.clear();
    }

    @FXML
    private void dataBtnOnAction(ActionEvent event) {
        DataSaveFXMLController data = new DataSaveFXMLController(this.sysData.primaryStage);
        data.show();
    }
}

