/*
 * Decompiled with CFR 0.152.
 */
package main;

import ControlSerial.CommFormat;
import Data.SystemData;
import Utility.EventBus.EventBusHandler;
import Utility.EventBus.EventBusListener;
import Utility.SongUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.apache.commons.lang3.math.NumberUtils;

public class MotionCalFXMLController
implements Initializable,
EventBusListener {
    SystemData sysData = SystemData.getInstance();
    private Stage myStage;
    private Scene myScene;
    private boolean threadStatus = true;
    private boolean eventBusSts = false;
    MotionCalFXMLController me;
    private boolean readFlag = false;
    @FXML
    private TextField rangeText;
    @FXML
    private Button readBtn;
    @FXML
    private Button writeBtn;
    @FXML
    private TextField pvText;
    @FXML
    private TextField compareText;

    public MotionCalFXMLController(Stage parent) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("MotionCalFXML.fxml"));
            loader.setControllerFactory(type -> {
                if (type == MotionCalFXMLController.class) {
                    return this;
                }
                try {
                    return type.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Parent root = (Parent)loader.load();
            this.myScene = new Scene(root);
            this.myStage = new Stage();
            this.myStage.initOwner((Window)parent);
            this.myStage.initModality(Modality.WINDOW_MODAL);
            this.myStage.setScene(this.myScene);
            this.myStage.setTitle("Motion Sensor Calibration");
            this.myStage.setResizable(false);
            this.myStage.getIcons().add((Object)new Image("/res32/adjust32_orange.png"));
            this.me = this;
            EventBusHandler.addListener(this);
        }
        catch (IOException ex) {
            System.out.println("MotionCalFXML Windows Load Error");
        }
    }

    public void show() {
        this.myStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                MotionCalFXMLController.this.threadStatus = false;
                System.out.println("user close");
                EventBusHandler.removeListener(MotionCalFXMLController.this.me);
            }
        });
        this.myStage.showAndWait();
    }

    @FXML
    void readBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(1);
            txFormat.setFuncCode(7);
            txFormat.setLength(1);
            txFormat.setTxData("REQ,");
            this.sysData.comm.setTxArray(txFormat);
            this.readFlag = true;
        } else {
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    @FXML
    void writeBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            String value = this.rangeText.getText();
            if (NumberUtils.isParsable((String)value)) {
                CommFormat txFormat = new CommFormat();
                txFormat.setAddr(1);
                txFormat.setFuncCode(8);
                txFormat.setLength(1);
                txFormat.setTxData(value + ",");
                this.sysData.comm.setTxArray(txFormat);
            } else {
                SongUtil.messageBox("Information", "Numeric invalid Alert", "Only numbers are allowed.");
            }
        } else {
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        new Thread(() -> {
            while (this.threadStatus) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Platform.runLater(() -> {
                    this.pvText.setText(String.format("%3.1f", this.sysData.sensor.Motion));
                    this.compareText.setText(String.format("%d", this.sysData.sensor.MotionDetect));
                    if (this.readFlag) {
                        this.rangeText.setText(String.format("%3.1f", this.sysData.sensor.motionCompare));
                        this.readFlag = false;
                    }
                });
            }
        }).start();
    }

    @Override
    public void onEvent(String id, String event) {
    }
}

