/*
 * Decompiled with CFR 0.152.
 */
package main;

import ControlSerial.CommFormat;
import Data.SystemData;
import DialogBox.WaitBoxFXMLController;
import Utility.EventBus.EventBusHandler;
import Utility.EventBus.EventBusListener;
import Utility.SongUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.apache.commons.lang3.math.NumberUtils;

public class NH3CalFXMLController
implements Initializable,
EventBusListener {
    SystemData sysData = SystemData.getInstance();
    private Stage myStage;
    private Scene myScene;
    private boolean threadStatus = true;
    private boolean eventBusSts = false;
    NH3CalFXMLController me;
    @FXML
    private TextField beforeText;
    @FXML
    private TextField afterText;
    @FXML
    private TextField zeromvText;
    @FXML
    private TextField spanmvText;
    @FXML
    private TextField zeroCalText;
    @FXML
    private TextField spanCalText;
    @FXML
    private Button readBtn;
    @FXML
    private Button zeroCalBtn;
    @FXML
    private Button spanCalBtn;
    @FXML
    private CheckBox zeroUserCheck;
    @FXML
    private CheckBox spanUserCheck;
    @FXML
    private Button writeBtn;
    @FXML
    private Button defaultBtn;

    public NH3CalFXMLController(Stage parent) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("NH3CalFXML.fxml"));
            loader.setControllerFactory(type -> {
                if (type == NH3CalFXMLController.class) {
                    return this;
                }
                try {
                    return type.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Parent root = (Parent)loader.load();
            this.myScene = new Scene(root);
            this.myStage = new Stage();
            this.myStage.initOwner((Window)parent);
            this.myStage.initModality(Modality.WINDOW_MODAL);
            this.myStage.setScene(this.myScene);
            this.myStage.setTitle("NH3 Sensor Calibration");
            this.myStage.setResizable(false);
            this.myStage.getIcons().add((Object)new Image("/res32/adjust32_orange.png"));
            this.me = this;
            EventBusHandler.addListener(this);
        }
        catch (IOException ex) {
            System.out.println("NH3CalFXMLController Windows Load Error");
        }
    }

    public void show() {
        this.myStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                NH3CalFXMLController.this.threadStatus = false;
                System.out.println("user close");
                EventBusHandler.removeListener(NH3CalFXMLController.this.me);
            }
        });
        this.myStage.showAndWait();
    }

    @FXML
    void readBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(1);
            txFormat.setFuncCode(46);
            txFormat.setLength(1);
            txFormat.setTxData("REQ,");
            this.sysData.comm.setTxArray(txFormat);
            WaitBoxFXMLController wait = new WaitBoxFXMLController(this.myStage);
            wait.show();
        } else {
            System.out.println("Comport Open Error");
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    @FXML
    void spanCalBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            String span = this.spanCalText.getText();
            String spanmV = null;
            if (this.spanUserCheck.isSelected()) {
                spanmV = this.spanmvText.getText();
            } else {
                this.spanmvText.setText(Double.toString(this.sysData.sensor.NH3mV));
                spanmV = this.zeromvText.getText();
            }
            if (NumberUtils.isParsable((String)span) && NumberUtils.isParsable((String)spanmV)) {
                if (this.spanUserCheck.isSelected()) {
                    this.sysData.sensor.spanNH3mV = Double.parseDouble(this.spanmvText.getText());
                } else {
                    this.sysData.sensor.spanNH3mV = this.sysData.sensor.NH3mV;
                    this.spanmvText.setText(String.format("%3.1f", this.sysData.sensor.spanNH3mV));
                }
                String mv0 = Double.toString(this.sysData.sensor.spanNH3mV);
                CommFormat txFormat = new CommFormat();
                txFormat.setAddr(1);
                txFormat.setFuncCode(48);
                txFormat.setLength(2);
                txFormat.setTxData(span + "," + mv0 + ",");
                this.sysData.comm.setTxArray(txFormat);
                this.sysData.sensor.nh3SpanCalFlag = true;
            } else {
                SongUtil.messageBox("Information", "Numeric invalid Alert", "Only numbers are allowed.");
            }
        } else {
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    @FXML
    void zeroCalBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            String zero = this.zeroCalText.getText();
            String zeromV = null;
            if (this.zeroUserCheck.isSelected()) {
                zeromV = this.zeromvText.getText();
            } else {
                this.zeromvText.setText(Double.toString(this.sysData.sensor.NH3mV));
                zeromV = this.zeromvText.getText();
            }
            if (NumberUtils.isParsable((String)zero) && NumberUtils.isParsable((String)zeromV)) {
                if (this.zeroUserCheck.isSelected()) {
                    this.sysData.sensor.zeroNH3mV = Double.parseDouble(this.zeromvText.getText());
                } else {
                    this.sysData.sensor.zeroNH3mV = this.sysData.sensor.NH3mV;
                    this.zeromvText.setText(String.format("%3.1f", this.sysData.sensor.zeroNH3mV));
                }
                String mv0 = Double.toString(this.sysData.sensor.zeroNH3mV);
                CommFormat txFormat = new CommFormat();
                txFormat.setAddr(1);
                txFormat.setFuncCode(47);
                txFormat.setLength(2);
                txFormat.setTxData(zero + "," + mv0 + ",");
                this.sysData.comm.setTxArray(txFormat);
                this.sysData.sensor.nh3ZeroCalFlag = true;
            } else {
                SongUtil.messageBox("Information", "Numeric invalid Alert", "Only numbers are allowed.");
            }
        } else {
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    @FXML
    void writeBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(1);
            txFormat.setFuncCode(49);
            txFormat.setLength(1);
            txFormat.setTxData("REQ,");
            this.sysData.comm.setTxArray(txFormat);
            WaitBoxFXMLController wait = new WaitBoxFXMLController(this.myStage);
            wait.show();
        } else {
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        new Thread(() -> {
            while (this.threadStatus) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Platform.runLater(() -> {
                    this.beforeText.setText(String.format("%3.1f", this.sysData.sensor.NH3mV));
                    this.afterText.setText(String.format("%3.2f", this.sysData.sensor.NH3));
                    if (this.sysData.sensor.nh3ReadFlag) {
                        this.zeromvText.setText(String.format("%3.1f", this.sysData.sensor.zeroNH3mV));
                        this.spanmvText.setText(String.format("%3.1f", this.sysData.sensor.spanNH3mV));
                        this.zeroCalText.setText(String.format("%3.1f", this.sysData.sensor.zeroNH3));
                        this.spanCalText.setText(String.format("%3.1f", this.sysData.sensor.spanNH3));
                        this.sysData.sensor.nh3ReadFlag = false;
                    }
                });
            }
        }).start();
    }

    @Override
    public void onEvent(String id, String event) {
    }

    @FXML
    private void defaultBtnOnAction(ActionEvent event) {
        this.zeroUserCheck.setSelected(true);
        this.spanUserCheck.setSelected(true);
        this.zeromvText.setText("0.0");
        this.zeroCalText.setText("0.0");
        this.spanmvText.setText("3000.0");
        this.spanCalText.setText("3000.0");
    }
}

