/*
 * Decompiled with CFR 0.152.
 */
package main;

import ControlSerial.CommFormat;
import Data.SystemData;
import Utility.EventBus.EventBusHandler;
import Utility.EventBus.EventBusListener;
import Utility.SongUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import main.InfoSFXMLController;

public class SetupFXMLController
implements Initializable,
EventBusListener {
    SystemData sysData = SystemData.getInstance();
    private Stage myStage;
    private Scene myScene;
    private boolean threadStatus = true;
    private boolean eventBusSts = false;
    SetupFXMLController me;
    @FXML
    private TextField deveuiText;
    @FXML
    private TextField appeuiText;
    @FXML
    private TextField appkeyText;
    @FXML
    private Button loraReadBtn;
    @FXML
    private Button loraWriteBtn;
    @FXML
    private TextField loraTimeText;
    @FXML
    private TextField ssidText;
    @FXML
    private TextField passwdText;
    @FXML
    private TextField wifiTimeText;
    @FXML
    private Button wifiReadBtn;
    @FXML
    private Button wifiWriteBtn;
    @FXML
    private TextField urlText;
    @FXML
    private TextField wifiidText;
    @FXML
    private CheckBox tempCheck;
    @FXML
    private CheckBox humiCheck;
    @FXML
    private CheckBox tvocCheck;
    @FXML
    private CheckBox lightCheck;
    @FXML
    private CheckBox coCheck;
    @FXML
    private CheckBox o3Check;
    @FXML
    private CheckBox co2Check;
    @FXML
    private CheckBox noiseCheck;
    @FXML
    private CheckBox dust25Check;
    @FXML
    private CheckBox dust10Check;
    @FXML
    private CheckBox no2Check;
    @FXML
    private CheckBox motionCheck;
    @FXML
    private CheckBox hchoCheck;
    @FXML
    private CheckBox wifiCheck;
    @FXML
    private CheckBox loraCheck;
    @FXML
    private ComboBox<String> freqCombo;
    @FXML
    private CheckBox memoryCheck;
    @FXML
    private TextField memoryTimeText;
    @FXML
    private TextField filenameText;
    @FXML
    private TextField dateText;
    @FXML
    private TextField currentRTCText;
    @FXML
    private TextField leoRTCText;
    @FXML
    private Button loraWriteBtn1;
    @FXML
    private TextField macText;
    @FXML
    private CheckBox nh3Check;
    @FXML
    private CheckBox dust01Check;

    public SetupFXMLController(Stage parent) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("SetupFXML.fxml"));
            loader.setControllerFactory(type -> {
                if (type == SetupFXMLController.class) {
                    return this;
                }
                try {
                    return type.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Parent root = (Parent)loader.load();
            this.myScene = new Scene(root);
            this.myStage = new Stage();
            this.myStage.initOwner((Window)parent);
            this.myStage.initModality(Modality.WINDOW_MODAL);
            this.myStage.setScene(this.myScene);
            this.myStage.setTitle("Setup");
            this.myStage.setResizable(false);
            this.myStage.getIcons().add((Object)new Image("/res32/setting32_orange.png"));
            this.me = this;
            EventBusHandler.addListener(this);
        }
        catch (IOException ex) {
            System.out.println("SetupFXML Windows Load Error");
        }
    }

    public void show() {
        this.myStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                SetupFXMLController.this.threadStatus = false;
                System.out.println("user close");
                EventBusHandler.removeListener(SetupFXMLController.this.me);
            }
        });
        this.myStage.showAndWait();
    }

    private void popupScreen() {
        InfoSFXMLController open = new InfoSFXMLController(this.sysData.primaryStage);
        open.show();
    }

    @FXML
    void loraReadBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(1);
            txFormat.setFuncCode(25);
            txFormat.setLength(1);
            txFormat.setTxData("REQ,");
            this.sysData.comm.setTxArray(txFormat);
            this.popupScreen();
        } else {
            System.out.println("Comport Open Error");
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    @FXML
    void loraWriteBtnOnAction(ActionEvent event) {
        if (this.appeuiText.getText().length() != 0 && this.appkeyText.getText().length() != 0 && this.loraTimeText.getText().length() != 0) {
            if (this.sysData.comm.comPort) {
                CommFormat txFormat = new CommFormat();
                txFormat.setAddr(1);
                txFormat.setFuncCode(26);
                txFormat.setLength(4);
                this.sysData.sensor.loraFreq = this.freqCombo.getSelectionModel().getSelectedIndex();
                String str = this.appeuiText.getText() + "," + this.appkeyText.getText() + "," + this.loraTimeText.getText() + "," + this.sysData.sensor.loraFreq + ",";
                txFormat.setTxData(str);
                this.sysData.comm.setTxArray(txFormat);
                this.popupScreen();
            } else {
                System.out.println("Comport Open Error");
                SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
            }
        } else {
            SongUtil.messageBox("Information", "Textfield is empty.", "Press ReadBtn to use.");
        }
    }

    @FXML
    void wifiReadBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(1);
            txFormat.setFuncCode(27);
            txFormat.setLength(1);
            txFormat.setTxData("REQ,");
            this.sysData.comm.setTxArray(txFormat);
            this.popupScreen();
        } else {
            System.out.println("Comport Open Error");
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    @FXML
    void wifiWriteBtnOnAction(ActionEvent event) {
        if (this.ssidText.getText().length() != 0 && this.passwdText.getText().length() != 0 && this.wifiTimeText.getText().length() != 0 && this.wifiidText.getText().length() != 0) {
            if (this.sysData.comm.comPort) {
                CommFormat txFormat = new CommFormat();
                txFormat.setAddr(1);
                txFormat.setFuncCode(28);
                txFormat.setLength(5);
                String str = this.ssidText.getText() + "," + this.passwdText.getText() + "," + this.urlText.getText() + "," + this.wifiTimeText.getText() + "," + this.wifiidText.getText() + ",";
                txFormat.setTxData(str);
                this.sysData.comm.setTxArray(txFormat);
                this.popupScreen();
            } else {
                System.out.println("Comport Open Error");
                SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
            }
        } else {
            SongUtil.messageBox("Information", "Textfield is empty.", "Press ReadBtn to use.");
        }
    }

    @FXML
    void clearBtnOnAction(ActionEvent event) {
        this.ssidText.setText("");
        this.passwdText.setText("");
        this.urlText.setText("");
        this.wifiTimeText.setText("");
        this.wifiidText.setText("");
        this.macText.setText("");
    }

    @FXML
    void senClrBtnOnAction(ActionEvent event) {
        this.tempCheck.setSelected(false);
        this.humiCheck.setSelected(false);
        this.tvocCheck.setSelected(false);
        this.lightCheck.setSelected(false);
        this.coCheck.setSelected(false);
        this.o3Check.setSelected(false);
        this.co2Check.setSelected(false);
        this.noiseCheck.setSelected(false);
        this.dust25Check.setSelected(false);
        this.dust10Check.setSelected(false);
        this.no2Check.setSelected(false);
        this.motionCheck.setSelected(false);
        this.wifiCheck.setSelected(false);
        this.loraCheck.setSelected(false);
        this.hchoCheck.setSelected(false);
        this.nh3Check.setSelected(false);
        this.dust01Check.setSelected(false);
    }

    @FXML
    void loraClrBtnOnAction(ActionEvent event) {
        this.deveuiText.setText("");
        this.appeuiText.setText("");
        this.appkeyText.setText("");
        this.loraTimeText.setText("");
    }

    @FXML
    void senReadBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(1);
            txFormat.setFuncCode(29);
            txFormat.setLength(1);
            txFormat.setTxData("REQ,");
            this.sysData.comm.setTxArray(txFormat);
            this.popupScreen();
        } else {
            System.out.println("Comport Open Error");
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    @FXML
    void senWriteBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            this.sysData.sensor.tempCheck = this.tempCheck.isSelected() ? 1 : 0;
            this.sysData.sensor.humiCheck = this.humiCheck.isSelected() ? 1 : 0;
            this.sysData.sensor.tvocCheck = this.tvocCheck.isSelected() ? 1 : 0;
            this.sysData.sensor.lightCheck = this.lightCheck.isSelected() ? 1 : 0;
            this.sysData.sensor.coCheck = this.coCheck.isSelected() ? 1 : 0;
            this.sysData.sensor.o3Check = this.o3Check.isSelected() ? 1 : 0;
            this.sysData.sensor.co2Check = this.co2Check.isSelected() ? 1 : 0;
            this.sysData.sensor.noiseCheck = this.noiseCheck.isSelected() ? 1 : 0;
            this.sysData.sensor.dust25Check = this.dust25Check.isSelected() ? 1 : 0;
            this.sysData.sensor.dust10Check = this.dust10Check.isSelected() ? 1 : 0;
            this.sysData.sensor.no2Check = this.no2Check.isSelected() ? 1 : 0;
            this.sysData.sensor.motionCheck = this.motionCheck.isSelected() ? 1 : 0;
            this.sysData.sensor.hchoCheck = this.hchoCheck.isSelected() ? 1 : 0;
            this.sysData.sensor.wifiCheck = this.wifiCheck.isSelected() ? 1 : 0;
            this.sysData.sensor.loraCheck = this.loraCheck.isSelected() ? 1 : 0;
            this.sysData.sensor.nh3Check = this.nh3Check.isSelected() ? 1 : 0;
            this.sysData.sensor.dust01Check = this.dust01Check.isSelected() ? 1 : 0;
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(1);
            txFormat.setFuncCode(30);
            txFormat.setLength(17);
            String str = this.sysData.sensor.tempCheck + "," + this.sysData.sensor.humiCheck + "," + this.sysData.sensor.tvocCheck + "," + this.sysData.sensor.lightCheck + "," + this.sysData.sensor.coCheck + "," + this.sysData.sensor.o3Check + "," + this.sysData.sensor.co2Check + "," + this.sysData.sensor.noiseCheck + "," + this.sysData.sensor.dust25Check + "," + this.sysData.sensor.dust10Check + "," + this.sysData.sensor.no2Check + "," + this.sysData.sensor.motionCheck + "," + this.sysData.sensor.hchoCheck + "," + this.sysData.sensor.wifiCheck + "," + this.sysData.sensor.loraCheck + "," + this.sysData.sensor.nh3Check + "," + this.sysData.sensor.dust01Check + ",";
            txFormat.setTxData(str);
            this.sysData.comm.setTxArray(txFormat);
            this.popupScreen();
        } else {
            System.out.println("Comport Open Error");
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    @FXML
    void logReadBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(1);
            txFormat.setFuncCode(31);
            txFormat.setLength(1);
            txFormat.setTxData("REQ,");
            this.sysData.comm.setTxArray(txFormat);
            this.popupScreen();
        } else {
            System.out.println("Comport Open Error");
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    @FXML
    void logWriteBtnOnAction(ActionEvent event) {
        if (this.memoryTimeText.getText().length() != 0 && this.filenameText.getText().length() != 0 && this.dateText.getText().length() != 0) {
            if (this.sysData.comm.comPort) {
                this.sysData.sensor.dataStartFlag = this.memoryCheck.isSelected() ? 1 : 0;
                this.sysData.sensor.dataInterval = Integer.parseInt(this.memoryTimeText.getText());
                this.sysData.sensor.dataLogName.setLength(0);
                this.sysData.sensor.dataLogName.append(this.filenameText.getText());
                this.sysData.sensor.dataStartDate.setLength(0);
                this.sysData.sensor.dataStartDate.append(this.dateText.getText());
                CommFormat txFormat = new CommFormat();
                txFormat.setAddr(1);
                txFormat.setFuncCode(32);
                txFormat.setLength(4);
                String txdata = this.sysData.sensor.dataStartFlag + "," + this.sysData.sensor.dataInterval + "," + this.sysData.sensor.dataLogName + "," + this.sysData.sensor.dataStartDate + ",";
                txFormat.setTxData(txdata);
                this.sysData.comm.setTxArray(txFormat);
                this.popupScreen();
            } else {
                System.out.println("Comport Open Error");
                SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
            }
        } else {
            SongUtil.messageBox("Information", "Textfield is empty.", "Press ReadBtn to use.");
        }
    }

    @FXML
    void logClrBtnOnAction(ActionEvent event) {
        this.memoryCheck.setSelected(false);
        this.memoryTimeText.setText("");
        this.filenameText.setText("");
        this.dateText.setText("");
    }

    @FXML
    void logNowBtnOnAction(ActionEvent event) {
        this.dateText.setText(SongUtil.nowDateTimeToFormatString());
    }

    @FXML
    void rtcReadBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(1);
            txFormat.setFuncCode(36);
            txFormat.setLength(1);
            txFormat.setTxData("REQ,");
            this.sysData.comm.setTxArray(txFormat);
            this.popupScreen();
        } else {
            System.out.println("Comport Open Error");
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    @FXML
    void rtcWriteBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            String time = SongUtil.nowDateTimeToFormatString2();
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(1);
            txFormat.setFuncCode(37);
            txFormat.setLength(6);
            txFormat.setTxData(time + ",");
            this.sysData.comm.setTxArray(txFormat);
            this.popupScreen();
        } else {
            System.out.println("Comport Open Error");
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.freqCombo.getItems().add((Object)"AS923");
        this.freqCombo.getItems().add((Object)"EU868");
        this.freqCombo.getItems().add((Object)"AU915");
        this.freqCombo.getItems().add((Object)"US915");
        this.freqCombo.getItems().add((Object)"IN865");
        this.freqCombo.getItems().add((Object)"KR920");
        this.freqCombo.getSelectionModel().select(0);
        this.freqCombo.setOnAction(e -> {
            System.out.println((String)this.freqCombo.getSelectionModel().getSelectedItem());
            int selFreq = this.freqCombo.getSelectionModel().getSelectedIndex();
            System.out.println("Index=" + selFreq);
        });
        new Thread(() -> {
            while (this.threadStatus) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Platform.runLater(() -> {
                    this.currentRTCText.setText(SongUtil.nowDateTimeToFormatString());
                    if (this.sysData.sensor.timeReadFlag) {
                        this.leoRTCText.setText(this.sysData.sensor.leoTime.toString());
                        this.sysData.sensor.timeReadFlag = false;
                    }
                    if (this.sysData.sensor.loraReadFlag) {
                        this.deveuiText.setText(this.sysData.sensor.loraDevEui.toString());
                        this.appeuiText.setText(this.sysData.sensor.loraAppEui.toString());
                        this.appkeyText.setText(this.sysData.sensor.loraAppKey.toString());
                        this.loraTimeText.setText(Integer.toString(this.sysData.sensor.loraInterval));
                        this.freqCombo.getSelectionModel().select(this.sysData.sensor.loraFreq);
                        this.sysData.sensor.loraReadFlag = false;
                    }
                    if (this.sysData.sensor.wifiReadFlag) {
                        this.ssidText.setText(this.sysData.sensor.wifiSSID.toString());
                        this.passwdText.setText(this.sysData.sensor.wifiPasswd.toString());
                        this.urlText.setText(this.sysData.sensor.wifiURL.toString());
                        this.wifiTimeText.setText(Integer.toString(this.sysData.sensor.wifiInterval));
                        this.wifiidText.setText(this.sysData.sensor.wifiID.toString());
                        this.macText.setText(this.sysData.sensor.wifiMAC.toString());
                        this.sysData.sensor.wifiReadFlag = false;
                    }
                    if (this.sysData.sensor.dataLogReadFlag) {
                        this.filenameText.setText(this.sysData.sensor.dataLogName.toString());
                        this.dateText.setText(this.sysData.sensor.dataStartDate.toString());
                        this.memoryTimeText.setText(Integer.toString(this.sysData.sensor.dataInterval));
                        if (this.sysData.sensor.dataStartFlag == 1) {
                            this.memoryCheck.setSelected(true);
                        } else {
                            this.memoryCheck.setSelected(false);
                        }
                        this.sysData.sensor.dataLogReadFlag = false;
                    }
                    if (this.sysData.sensor.sensorReadFlag) {
                        if (this.sysData.sensor.tempCheck == 1) {
                            this.tempCheck.setSelected(true);
                        } else {
                            this.tempCheck.setSelected(false);
                        }
                        if (this.sysData.sensor.humiCheck == 1) {
                            this.humiCheck.setSelected(true);
                        } else {
                            this.humiCheck.setSelected(false);
                        }
                        if (this.sysData.sensor.tvocCheck == 1) {
                            this.tvocCheck.setSelected(true);
                        } else {
                            this.tvocCheck.setSelected(false);
                        }
                        if (this.sysData.sensor.lightCheck == 1) {
                            this.lightCheck.setSelected(true);
                        } else {
                            this.lightCheck.setSelected(false);
                        }
                        if (this.sysData.sensor.coCheck == 1) {
                            this.coCheck.setSelected(true);
                        } else {
                            this.coCheck.setSelected(false);
                        }
                        if (this.sysData.sensor.o3Check == 1) {
                            this.o3Check.setSelected(true);
                        } else {
                            this.o3Check.setSelected(false);
                        }
                        if (this.sysData.sensor.co2Check == 1) {
                            this.co2Check.setSelected(true);
                        } else {
                            this.co2Check.setSelected(false);
                        }
                        if (this.sysData.sensor.noiseCheck == 1) {
                            this.noiseCheck.setSelected(true);
                        } else {
                            this.noiseCheck.setSelected(false);
                        }
                        if (this.sysData.sensor.dust25Check == 1) {
                            this.dust25Check.setSelected(true);
                        } else {
                            this.dust25Check.setSelected(false);
                        }
                        if (this.sysData.sensor.dust10Check == 1) {
                            this.dust10Check.setSelected(true);
                        } else {
                            this.dust10Check.setSelected(false);
                        }
                        if (this.sysData.sensor.no2Check == 1) {
                            this.no2Check.setSelected(true);
                        } else {
                            this.no2Check.setSelected(false);
                        }
                        if (this.sysData.sensor.motionCheck == 1) {
                            this.motionCheck.setSelected(true);
                        } else {
                            this.motionCheck.setSelected(false);
                        }
                        if (this.sysData.sensor.hchoCheck == 1) {
                            this.hchoCheck.setSelected(true);
                        } else {
                            this.hchoCheck.setSelected(false);
                        }
                        if (this.sysData.sensor.wifiCheck == 1) {
                            this.wifiCheck.setSelected(true);
                        } else {
                            this.wifiCheck.setSelected(false);
                        }
                        if (this.sysData.sensor.loraCheck == 1) {
                            this.loraCheck.setSelected(true);
                        } else {
                            this.loraCheck.setSelected(false);
                        }
                        if (this.sysData.sensor.nh3Check == 1) {
                            this.nh3Check.setSelected(true);
                        } else {
                            this.nh3Check.setSelected(false);
                        }
                        if (this.sysData.sensor.dust01Check == 1) {
                            this.dust01Check.setSelected(true);
                        } else {
                            this.dust01Check.setSelected(false);
                        }
                        this.sysData.sensor.sensorReadFlag = false;
                    }
                });
            }
        }).start();
    }

    @Override
    public void onEvent(String id, String event) {
    }
}

