/*
 * Decompiled with CFR 0.152.
 */
package main;

import ControlSerial.CommFormat;
import Data.SystemData;
import Utility.EventBus.EventBusHandler;
import Utility.EventBus.EventBusListener;
import Utility.SongUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import main.InfoSFXMLController;
import org.apache.commons.lang3.math.NumberUtils;

public class TVOCCalFXMLController
implements Initializable,
EventBusListener {
    SystemData sysData = SystemData.getInstance();
    private Stage myStage;
    private Scene myScene;
    private boolean threadStatus = true;
    private boolean eventBusSts = false;
    TVOCCalFXMLController me;
    @FXML
    private TextField beforeTVOCText;
    @FXML
    private TextField afterTVOCText;
    @FXML
    private TextField calBText;
    @FXML
    private TextField calAText;

    public TVOCCalFXMLController(Stage parent) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("TVOCCalFXML.fxml"));
            loader.setControllerFactory(type -> {
                if (type == TVOCCalFXMLController.class) {
                    return this;
                }
                try {
                    return type.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Parent root = (Parent)loader.load();
            this.myScene = new Scene(root);
            this.myStage = new Stage();
            this.myStage.initOwner((Window)parent);
            this.myStage.initModality(Modality.WINDOW_MODAL);
            this.myStage.setScene(this.myScene);
            this.myStage.setTitle("TVOC Sensor Calibration");
            this.myStage.setResizable(false);
            this.myStage.getIcons().add((Object)new Image("/res32/adjust32_orange.png"));
            this.me = this;
            EventBusHandler.addListener(this);
        }
        catch (IOException ex) {
            System.out.println("TVOCCalFXMLController Windows Load Error");
        }
    }

    public void show() {
        this.myStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                TVOCCalFXMLController.this.threadStatus = false;
                System.out.println("user close");
                EventBusHandler.removeListener(TVOCCalFXMLController.this.me);
            }
        });
        this.myStage.showAndWait();
    }

    private void popupScreen() {
        InfoSFXMLController open = new InfoSFXMLController(this.sysData.primaryStage);
        open.show();
    }

    @FXML
    void readBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(1);
            txFormat.setFuncCode(42);
            txFormat.setLength(1);
            txFormat.setTxData("REQ,");
            this.sysData.comm.setTxArray(txFormat);
            this.popupScreen();
        } else {
            System.out.println("Comport Open Error");
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    @FXML
    void writeBtnOnAction(ActionEvent event) {
        String calA = this.calAText.getText();
        String calB = this.calBText.getText();
        if (NumberUtils.isParsable((String)calA) && NumberUtils.isParsable((String)calB)) {
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(1);
            txFormat.setFuncCode(43);
            txFormat.setLength(2);
            txFormat.setTxData(calA + "," + calB + ",");
            this.sysData.comm.setTxArray(txFormat);
            this.sysData.sensor.tempCalFlag = true;
            System.out.println("TVOC CalData = " + calA + "," + calB);
            this.popupScreen();
        } else {
            SongUtil.messageBox("Information", "Numeric invalid Alert", "Only numbers are allowed.");
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        new Thread(() -> {
            while (this.threadStatus) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Platform.runLater(() -> {
                    this.beforeTVOCText.setText(String.format("%3.1f", this.sysData.sensor.TVOCmV));
                    if (this.sysData.sensor.tvocReadFlag) {
                        this.calAText.setText(String.format("%3.3f", this.sysData.sensor.tvocCalA));
                        this.calBText.setText(String.format("%3.3f", this.sysData.sensor.tvocCalB));
                        this.sysData.sensor.tvocReadFlag = false;
                    }
                    this.afterTVOCText.setText(String.format("%3.2f", this.sysData.sensor.TVOC));
                });
            }
        }).start();
    }

    @Override
    public void onEvent(String id, String event) {
    }

    @FXML
    private void closeBtnOnAction(ActionEvent event) {
        this.threadStatus = false;
        System.out.println("user close");
        EventBusHandler.removeListener(this.me);
        Window window = this.myScene.getWindow();
        if (window instanceof Stage) {
            ((Stage)window).close();
        }
    }
}

