/*
 * Decompiled with CFR 0.152.
 */
package main;

import ControlSerial.CommFormat;
import Data.SystemData;
import Utility.EventBus.EventBusHandler;
import Utility.EventBus.EventBusListener;
import Utility.SongUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import main.InfoSFXMLController;
import org.apache.commons.lang3.math.NumberUtils;

public class TempCalFXMLController
implements EventBusListener,
Initializable {
    SystemData sysData = SystemData.getInstance();
    private Stage myStage;
    private Scene myScene;
    private boolean threadStatus = true;
    private boolean eventBusSts = false;
    TempCalFXMLController me;
    @FXML
    private TextField beforeTempText;
    @FXML
    private TextField afterTempText;
    @FXML
    private TextField beforeHumiText;
    @FXML
    private TextField afterHumiText;
    @FXML
    private TextField calHumiBText;
    @FXML
    private TextField calTempBText;
    @FXML
    private TextField calTempAText;
    @FXML
    private TextField calHumiAText;
    @FXML
    private TextField calTempB1Text;
    @FXML
    private TextField calTempA1Text;
    @FXML
    private TextField calTempB2Text;
    @FXML
    private TextField calTempA2Text;
    @FXML
    private TextField calTempB3Text;
    @FXML
    private TextField calTempA3Text;
    @FXML
    private TextField tempRange1;
    @FXML
    private TextField tempRange2;
    @FXML
    private TextField tempRange3;
    @FXML
    private TextField tempRange4;

    public TempCalFXMLController(Stage parent) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("TempCalFXML.fxml"));
            loader.setControllerFactory(type -> {
                if (type == TempCalFXMLController.class) {
                    return this;
                }
                try {
                    return type.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Parent root = (Parent)loader.load();
            this.myScene = new Scene(root);
            this.myStage = new Stage();
            this.myStage.initOwner((Window)parent);
            this.myStage.initModality(Modality.WINDOW_MODAL);
            this.myStage.setScene(this.myScene);
            this.myStage.setTitle("Temp & Humi Calibration");
            this.myStage.setResizable(false);
            this.myStage.getIcons().add((Object)new Image("/res32/adjust32_orange.png"));
            this.me = this;
            EventBusHandler.addListener(this);
        }
        catch (IOException ex) {
            System.out.println("TempCalFXML Windows Load Error");
        }
    }

    public void show() {
        this.myStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                TempCalFXMLController.this.threadStatus = false;
                System.out.println("user close");
                EventBusHandler.removeListener(TempCalFXMLController.this.me);
            }
        });
        this.myStage.showAndWait();
    }

    @FXML
    void closeBtnOnAction(ActionEvent event) {
        this.threadStatus = false;
        System.out.println("user close");
        EventBusHandler.removeListener(this.me);
        Window window = this.myScene.getWindow();
        if (window instanceof Stage) {
            ((Stage)window).close();
        }
    }

    private void popupScreen() {
        InfoSFXMLController open = new InfoSFXMLController(this.sysData.primaryStage);
        open.show();
    }

    @FXML
    void readBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(1);
            txFormat.setFuncCode(34);
            txFormat.setLength(1);
            txFormat.setTxData("REQ,");
            this.sysData.comm.setTxArray(txFormat);
            this.popupScreen();
        } else {
            System.out.println("Comport Open Error");
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    @FXML
    void writeBtnOnAction(ActionEvent event) {
        String caltempA = this.calTempAText.getText();
        String caltempB = this.calTempBText.getText();
        String calhumiA = this.calHumiAText.getText();
        String calhumiB = this.calHumiBText.getText();
        String caltempA1 = this.calTempA1Text.getText();
        String caltempB1 = this.calTempB1Text.getText();
        String caltempA2 = this.calTempA2Text.getText();
        String caltempB2 = this.calTempB2Text.getText();
        String caltempA3 = this.calTempA3Text.getText();
        String caltempB3 = this.calTempB3Text.getText();
        String tRange1 = this.tempRange1.getText();
        String tRange2 = this.tempRange2.getText();
        String tRange3 = this.tempRange3.getText();
        String tRange4 = this.tempRange4.getText();
        if (NumberUtils.isParsable((String)caltempA) && NumberUtils.isParsable((String)caltempB) && NumberUtils.isParsable((String)calhumiA) && NumberUtils.isParsable((String)calhumiB) && NumberUtils.isParsable((String)caltempA1) && NumberUtils.isParsable((String)caltempB1) && NumberUtils.isParsable((String)caltempA2) && NumberUtils.isParsable((String)caltempB2) && NumberUtils.isParsable((String)caltempA3) && NumberUtils.isParsable((String)caltempB3) && NumberUtils.isParsable((String)tRange1) && NumberUtils.isParsable((String)tRange2) && NumberUtils.isParsable((String)tRange3) && NumberUtils.isParsable((String)tRange4)) {
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(1);
            txFormat.setFuncCode(35);
            txFormat.setLength(14);
            txFormat.setTxData(caltempA + "," + caltempB + "," + calhumiA + "," + calhumiB + "," + caltempA1 + "," + caltempB1 + "," + caltempA2 + "," + caltempB2 + "," + caltempA3 + "," + caltempB3 + "," + tRange1 + "," + tRange2 + "," + tRange3 + "," + tRange4 + ",");
            this.sysData.comm.setTxArray(txFormat);
            this.sysData.sensor.tempCalFlag = true;
            System.out.println("TempCalData = " + caltempA + "," + caltempB + "," + calhumiA + "," + calhumiB + "Range1=" + tRange1);
            System.out.println("TempCalData1 = " + caltempA1 + "," + caltempB1 + "," + tRange2);
            System.out.println("TempCalData2 = " + caltempA2 + "," + caltempB2 + "," + tRange3);
            System.out.println("TempCalData3 = " + caltempA3 + "," + caltempB3 + "," + tRange4);
            this.popupScreen();
        } else {
            SongUtil.messageBox("Information", "Numeric invalid Alert", "Only numbers are allowed.");
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        new Thread(() -> {
            while (this.threadStatus) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Platform.runLater(() -> {
                    this.beforeTempText.setText(String.format("%3.1f", this.sysData.sensor.TempSrc));
                    this.beforeHumiText.setText(String.format("%3.1f", this.sysData.sensor.HumiSrc));
                    if (this.sysData.sensor.tempReadFlag) {
                        this.calTempAText.setText(String.format("%3.3f", this.sysData.sensor.calTempA));
                        this.calTempBText.setText(String.format("%3.3f", this.sysData.sensor.calTempB));
                        this.calHumiAText.setText(String.format("%3.3f", this.sysData.sensor.calHumiA));
                        this.calHumiBText.setText(String.format("%3.3f", this.sysData.sensor.calHumiB));
                        this.calTempA1Text.setText(String.format("%3.3f", this.sysData.sensor.calTempA1));
                        this.calTempB1Text.setText(String.format("%3.3f", this.sysData.sensor.calTempB1));
                        this.calTempA2Text.setText(String.format("%3.3f", this.sysData.sensor.calTempA2));
                        this.calTempB2Text.setText(String.format("%3.3f", this.sysData.sensor.calTempB2));
                        this.calTempA3Text.setText(String.format("%3.3f", this.sysData.sensor.calTempA3));
                        this.calTempB3Text.setText(String.format("%3.3f", this.sysData.sensor.calTempB3));
                        this.tempRange1.setText(String.format("%3.1f", this.sysData.sensor.calTempRange1));
                        this.tempRange2.setText(String.format("%3.1f", this.sysData.sensor.calTempRange2));
                        this.tempRange3.setText(String.format("%3.1f", this.sysData.sensor.calTempRange3));
                        this.tempRange4.setText(String.format("%3.1f", this.sysData.sensor.calTempRange4));
                        this.sysData.sensor.tempReadFlag = false;
                    }
                    this.afterTempText.setText(String.format("%3.1f", this.sysData.sensor.Temp));
                    this.afterHumiText.setText(String.format("%3.1f", this.sysData.sensor.Humi));
                });
            }
        }).start();
    }

    @Override
    public void onEvent(String id, String event) {
    }
}

