/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.AbstractGrabber;
import au.edu.jcu.v4l4j.BaseVideoFrame;
import au.edu.jcu.v4l4j.exceptions.UnsupportedMethod;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

class JPEGVideoFrame
extends BaseVideoFrame {
    JPEGVideoFrame(AbstractGrabber grabber, int bufferSize) {
        super(grabber, bufferSize);
    }

    @Override
    protected WritableRaster refreshRaster() {
        throw new UnsupportedMethod("A raster cannot be generated for a JPEG frame");
    }

    @Override
    protected BufferedImage refreshBufferedImage() {
        try {
            return ImageIO.read(new ByteArrayInputStream(this.frameBuffer, 0, this.frameLength));
        }
        catch (IOException e) {
            String[] supportedMimeTypes;
            String[] supportedTypes;
            System.err.println("It seems your JVM is unable to decode this image.");
            System.err.println("Supported image types:");
            for (String name : supportedTypes = ImageIO.getReaderFormatNames()) {
                System.err.println(name);
            }
            System.err.println("Supported MIME types:");
            for (String name : supportedMimeTypes = ImageIO.getReaderMIMETypes()) {
                System.err.println(name);
            }
            e.printStackTrace();
            throw new UnsupportedMethod("Unable to decode the image", e);
        }
    }
}

