/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.v4l4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Arrays;

public class NativeUtils {
    private NativeUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibraryFromJar(String jarpath, String[] libs) throws IOException {
        File libspath = File.createTempFile("libs", "");
        if (!libspath.delete()) {
            throw new IOException("Cannot clean " + libspath);
        }
        if (!libspath.exists() && !libspath.mkdirs()) {
            throw new IOException("Cannot create directory " + libspath);
        }
        libspath.deleteOnExit();
        try {
            NativeUtils.addLibraryPath(libspath.getAbsolutePath());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        for (String lib : libs) {
            String libfile = "lib" + lib + ".so";
            String path = jarpath + "/" + libfile;
            if (!path.startsWith("/")) {
                throw new IllegalArgumentException("The path to be absolute (start with '/').");
            }
            File file = new File(libspath, libfile);
            file.createNewFile();
            file.deleteOnExit();
            byte[] buffer = new byte[1024];
            InputStream is = NativeUtils.class.getResourceAsStream(path);
            if (is == null) {
                throw new FileNotFoundException("File " + path + " was not found inside JAR.");
            }
            FileOutputStream os = new FileOutputStream(file);
            try {
                int readBytes;
                while ((readBytes = is.read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, readBytes);
                }
            }
            finally {
                ((OutputStream)os).close();
                is.close();
            }
        }
        for (String lib : libs) {
            System.loadLibrary(lib);
        }
    }

    public static void addLibraryPath(String pathToAdd) throws Exception {
        String[] paths;
        Field usrPathsField = ClassLoader.class.getDeclaredField("usr_paths");
        usrPathsField.setAccessible(true);
        for (String path : paths = (String[])usrPathsField.get(null)) {
            if (!path.equals(pathToAdd)) continue;
            return;
        }
        String[] newPaths = Arrays.copyOf(paths, paths.length + 1);
        newPaths[newPaths.length - 1] = pathToAdd;
        usrPathsField.set(null, newPaths);
    }
}

